/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpCommon.GraphInstance;
import ibm.nways.analysis.dpCommon.ViewInstance;
import ibm.nways.analysis.dpManager.DpmClientApplet;
import ibm.nways.nhm.eui.NhmViewPage;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Enumeration;
import java.util.Vector;
import jclass.chart.ChartDataView;
import jclass.chart.Chartable;
import jclass.chart.JCChart;

public class NhmView
extends NhmViewPage
implements ComponentListener {
    String title;
    ViewInstance vi;
    DpmClientApplet server;

    public NhmView(String string) {
        this(string, null);
    }

    public NhmView(String string, DpmClientApplet dpmClientApplet) {
        this.title = string;
        this.server = dpmClientApplet;
        this.addComponentListener(this);
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.unregisterForEvents();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.registerForEvents();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void unregisterForEvents() {
        this.unregisterForEvents(this.server);
    }

    public void unregisterForEvents(DpmClientApplet dpmClientApplet) {
        if (this.vi != null && dpmClientApplet != null) {
            this.vi.unregisterForEvents(dpmClientApplet);
        }
    }

    public void registerForEvents() {
        if (this.vi != null && this.server != null) {
            this.vi.registerForEvents(this.server);
        }
    }

    public void setCurrentChartType(int n) {
        Chartable chartable;
        JCChart jCChart;
        ChartDataView chartDataView;
        Component component = this.getCurrentComponent();
        if (component instanceof JCChart && (chartDataView = (jCChart = (JCChart)component).getDataView(0)) != null && (chartable = chartDataView.getDataSource()) != null && chartable instanceof GraphInstance) {
            GraphInstance graphInstance = (GraphInstance)chartable;
            graphInstance.setChartType(n);
        }
    }

    public ViewInstance getViewInstance() {
        return this.vi;
    }

    public void setViewInstance(ViewInstance viewInstance) {
        this.vi = viewInstance;
        this.recreateView();
    }

    public String getTitle() {
        return this.title;
    }

    public void updateComponent(Component component) {
        component.repaint();
    }

    public void updateView() {
        Component component = null;
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            component = (Component)enumeration.nextElement();
            this.updateComponent(component);
        }
    }

    public void recreateView() {
        this.removeAll();
        Vector vector = this.vi.getGraphs();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            GraphInstance graphInstance = (GraphInstance)enumeration.nextElement();
            JCChart jCChart = graphInstance.getGraph(this);
            this.addComponent(jCChart);
        }
    }
}

